function timestep_helper(state)
% timestep_helper.m

global u1 u2 rho mu xf yf;
global u1_start u2_start rho_start mu_start xf_start yf_start;
global xf2 yf2 rad2 xf2_start yf2_start;

% beginning of timestep, copy current solution to temporary arrays
if state==1
    u1_start  = u1;
    u2_start  = u2;
    rho_start = rho;
    mu_start  = mu;
    
    xf_start  = xf;
    yf_start  = yf;
    if exist('rad2','var')
        xf2_start = xf2;
        yf2_start = yf2;
    end
end

% end of timestep, apply update as average of beginning of big timestep and
% end of big timestep, having taken two substeps of Delta_t/2 (eqn 12)
if state==2
    u1  = 0.5*(u1+u1_start);
    u2  = 0.5*(u2+u2_start);
    rho = 0.5*(rho+rho_start);
    mu  = 0.5*(mu+mu_start);
    
    xf = 0.5*(xf+xf_start);
    yf = 0.5*(yf+yf_start);
    if exist('rad2','var')
        xf2 = 0.5*(xf2+xf2_start);
        yf2 = 0.5*(yf2*yf2_start);
    end
end
