% setup_globals_one_drop.m

% config
global Lx Ly gx gy rho1 rho2 mu1 mu2 sigma;

Lx    = 1.0;
Ly    = 1.0;
gx    = 0.0;
gy    = 200.0; % 200
rho1  = 1.0;
rho2  = 2.0;  % 2
mu1   = 0.02;
mu2   = 0.10;
sigma = 10; %1

global time;
time = 0.0; 

% drop radius and center position
global rad xc yc;

rad = 0.15;
xc  = 0.5;
yc  = 0.75;

% discretization config
global nx ny dt nstep Nf;
global sor_maxiter sor_err_tol sor_omega;

nx    = 32;
ny    = 32;
dt    = 0.00125;
nstep = 250;
Nf    = 100;

sor_maxiter = 200;
sor_err_tol = 0.001;
sor_omega   = 1.5;

% solution arrays
global u1 u2 pres u1t u2t temp1 uu1 uu2 temp2 fx fy u1_start u2_start;

u1    = zeros(nx+1,ny+2);
u2    = zeros(nx+2,ny+1);
pres  = zeros(nx+2,ny+2);
u1t   = zeros(nx+1,ny+2);
u2t   = zeros(nx+2,ny+1);
uu1   = zeros(nx+1,ny+1);
uu2   = zeros(nx+1,ny+1);
fx    = zeros(nx+2,ny+2);
fy    = zeros(nx+2,ny+2);
temp1 = zeros(nx+2,ny+2); 
temp2 = zeros(nx+2,ny+2);

u1_start = zeros(nx+1,ny+2);
u2_start = zeros(nx+2,ny+1);

% make grid points
global dx dy;

dx = Lx/nx;
dy = Ly/ny;

for i=1:nx+2
    x(i) = dx*(i-1.5);
end
for j=1:ny+2
    y(j) = dy*(j-1.5);
end