function [xf,yf,xf_start,yf_start] = setup_front_drop(xc,yc,rad,Nf)
% setup_front_two_drops.m

% front points (x,y) positions
xf = zeros(1,Nf+2);
yf = zeros(1,Nf+2);

% start of timestep copies for PC
xf_start = zeros(1,Nf+2);
yf_start = zeros(1,Nf+2);

% front point velocities and tangent vectors
u1f = zeros(1,Nf+2);
u2f = zeros(1,Nf+2);
tx  = zeros(1,Nf+2);
ty  = zeros(1,Nf+2);

% set circular IC
xf = xc - rad * sin(2*pi*linspace(0,Nf+1,Nf+2)/Nf);
yf = yc + rad * cos(2*pi*linspace(0,Nf+1,Nf+2)/Nf);