% setup_ICs.m

global rho mu rho_start mu_start u1 u2;

% density and viscosity
rho = zeros(nx+2,ny+2) + rho1;
mu  = zeros(nx+2,ny+2) + mu1; 

% start of timestep copies for PC
rho_start = zeros(nx+2,ny+2);
mu_start  = zeros(nx+2,ny+2);

% override if inside drop
for i=2:nx+1
    for j=2:ny+1
        
        % first drop
        if ( (x(i)-xc)^2+(y(j)-yc)^2 < rad^2)
            rho(i,j) = rho2;
            mu(i,j)  = mu2;
        end
        
        % second drop if it exists
        if exist('xc2','var')
            if ( (x(i)-xc2)^2+(y(j)-yc2)^2 < rad2^2)
                rho(i,j) = rho3;
                mu(i,j)  = mu3;
                
                % give the second drop an upward starting velocity
                u2(i,j) = 10.0;
                u1(i,j) = 0.0;
            end
        end
        
    end
end