function reconstruct_density_mu(xf,yf,Nf,rho2,mu2,last_drop_flag)
% reconstruct_density_mu.m
% rho2/mu2 is of the drop under consideration

global dx dy nx ny rho1 mu1 rho mu fx fy;
global sor_maxiter sor_omega sor_err_tol;

% smooth interface gradient onto fixed grid
fx = zeros(nx+2,ny+2);
fy = zeros(nx+2,ny+2);

for i=2:Nf+1
   % normal vectors
   nfx = -0.5*(yf(i+1)-yf(i-1))*(rho2-rho1);   
   nfy =  0.5*(xf(i+1)-xf(i-1))*(rho2-rho1);

   % (x) nearest indices
   ip = floor(xf(i)/dx) + 1;
   jp = floor((yf(i)+0.5*dy)/dy) + 1;
   
   % dists to nearest indices
   ax = xf(i)/dx - ip + 1;
   ay = (yf(i)+0.5*dy)/dy - jp + 1;
   
   % bilinear interp (eqn 36)
   fx(ip,jp)    = fx(ip,jp)     + (1.0-ax)* (1.0-ay) * nfx/dx/dy;
   fx(ip+1,jp)  = fx(ip+1,jp)   + ax      * (1.0-ay) * nfx/dx/dy;
   fx(ip,jp+1)  = fx(ip,jp+1)   + (1.0-ax)* ay       * nfx/dx/dy;
   fx(ip+1,jp+1)= fx(ip+1,jp+1) + ax      * ay       * nfx/dx/dy;

   % (y)
   ip = floor((xf(i)+0.5*dx)/dx) + 1;
   jp = floor(yf(i)/dy) + 1;
   
   ax = (xf(i)+0.5*dx)/dx - ip + 1;
   ay = yf(i)/dy - jp + 1;
   
   fy(ip,jp)    = fy(ip,jp)    + (1.0-ax) * (1.0-ay) * nfy/dx/dy;
   fy(ip+1,jp)  = fy(ip+1,jp)  + ax       * (1.0-ay) * nfy/dx/dy;
   fy(ip,jp+1)  = fy(ip,jp+1)  + (1.0-ax) * ay       * nfy/dx/dy;
   fy(ip+1,jp+1)= fy(ip+1,jp+1)+ ax       * ay       * nfy/dx/dy;
end

% only do the density/viscosity reconstruction after all drops have added
% their contributions to fx,fy
if last_drop_flag == 1

    % SOR iteration for density
    for kk=1:sor_maxiter
        rho_last = rho;

        for i=2:nx+1
            for j=2:ny+1
                rho(i,j) = sor_omega * ... % eqn 38
                           0.25 * ( rho(i+1,j) + rho(i-1,j) + rho(i,j+1) + rho(i,j-1) + ...
                                    dx * fx(i-1,j) - dx * fx(i,j) + ...
                                    dy * fy(i,j-1) - dy * fy(i,j) ) + ...
                           (1.0-sor_omega) * rho(i,j);
            end
        end

        if max(max( abs(rho_last-rho) )) < sor_err_tol
            break;
        end
    end

    % set viscosity (this dosen't work so well for two drops)
    mu = zeros(nx+2,ny+2) + mu1;

    for i=2:nx+1
        for j=2:ny+1
            mu(i,j) = mu1 + (mu2-mu1) * (rho(i,j)-rho1)/(rho2-rho1);
        end
    end

end % last_drop_flag
