% pressure_correction_vel.m

% Compute source term and the coefficient for p(i,j)
rho_temp = rho;

% kill boundary equations with large denom
rho_temp(1:nx+2,1)    = 1e5;
rho_temp(1:nx+2,ny+2) = 1e5;
rho_temp(1,1:ny+2)    = 1e5;
rho_temp(nx+2,1:ny+2) = 1e5;

% eqn 27/28
for i=2:nx+1
    for j=2:ny+1
        % velocity interpolates (cal G)
        temp1(i,j) = (0.5/dt) * ( (u1t(i,j)-u1t(i-1,j))/dx + ...
                                  (u2t(i,j)-u2t(i,j-1))/dy );
        
        % density interpolates (cal H)
        temp2(i,j) = ...
        1.0/( (1.0/dx) * ( 1.0/( dx*(rho_temp(i+1,j)+rho_temp(i,j)) ) + ...
                           1.0/( dx*(rho_temp(i-1,j)+rho_temp(i,j)) ) ) + ...
              (1.0/dy) * ( 1.0/( dy*(rho_temp(i,j+1)+rho_temp(i,j)) ) + ...
                           1.0/( dy*(rho_temp(i,j-1)+rho_temp(i,j)) ) ) );
    end
end

% SOR iteration for pressure correction (eqn 29)
for it=1:sor_maxiter
    pres_old = pres;
    
    for i=2:nx+1
        for j=2:ny+1
            pres(i,j) = sor_omega * temp2(i,j) * ( ...
            ...
            (1.0/dx)*( pres(i+1,j)/(dx*(rho_temp(i+1,j)+rho_temp(i,j))) + ... % cal F terms
                       pres(i-1,j)/(dx*(rho_temp(i-1,j)+rho_temp(i,j))) )       + ...
            ...
            (1.0/dy)*( pres(i,j+1)/(dy*(rho_temp(i,j+1)+rho_temp(i,j)))         + ...
                       pres(i,j-1)/(dy*(rho_temp(i,j-1)+rho_temp(i,j))) ) - temp1(i,j)) + ...
            ...
            (1.0-sor_omega)*pres(i,j);
        end
    end
    
    if max(max( abs(pres_old-pres) )) < sor_err_tol
        break;
    end
end

% u_1 (eqn 21)
for i=2:nx
    for j=2:ny+1
        u1(i,j) = u1t(i,j) - dt*(2.0/dx) * ...
            (pres(i+1,j)-pres(i,j))/(rho(i+1,j)+rho(i,j));
    end
end

% u_2 (eqn 22)
for i=2:nx+1
    for j=2:ny
        u2(i,j) = u2t(i,j) - dt*(2.0/dy) * ...
            (pres(i,j+1)-pres(i,j))/(rho(i,j+1)+rho(i,j));
    end
end