% plot_drop_trails.m

xh = linspace(0,Lx,nx+1);
yh = linspace(0,Ly,ny+1);

% color map
colormap(jet)
cmap = colormap;
cmap_ind = floor(curstep/nstep * length(cmap));
if cmap_ind == 0
    cmap_ind = 1;
end

cur_color = cmap( cmap_ind,: );

% drop interface
axis equal
axis([xc-2*rad xc+2*rad 0 Ly]);
plot([xf(1:Nf) xf(1)],[yf(1:Nf) yf(1)],'Color',cur_color,'linewidth',2);
if exist('rad2','var')
    plot([xf2(1:Nf2) xf2(1)],[yf2(1:Nf2) yf2(1)],'--','Color',cur_color,'linewidth',2);
end
hold on
pause(0.01)