% plot_4panels.m

hold off
subplot1(2,2)

uu1(1:nx+1,1:ny+1) = 0.5 * (u1(1:nx+1,2:ny+2)+u1(1:nx+1,1:ny+1));
uu2(1:nx+1,1:ny+1) = 0.5 * (u2(2:nx+2,1:ny+1)+u2(1:nx+1,1:ny+1));

%usq = sqrt(uu1.*uu1 + uu2.*uu2);

xh = linspace(0,Lx,nx+1);
yh = linspace(0,Ly,ny+1);

% density contour
cvals = [0.499,0.5,0.501,0.55,0.6,0.7,0.8,0.9,1.0]*rho2;
subplot1(1)
contour(x,y,rho',cvals,'linewidth',1.5);
hold on

axis equal
axis([0 Lx 0 Ly]);
plot([xf(1:Nf) xf(1)],[yf(1:Nf) yf(1)],'k','linewidth',2); % drop interface 1
if exist('rad2','var')
    plot([xf2(1:Nf2) xf2(1)],[yf2(1:Nf2) yf2(1)],'k','linewidth',2); % drop interface 2
end
text(0.9,0.9,'$\rho$','interpreter','latex');
hold off

% velocity vector plot
subplot1(2)
quiver(xh,yh,uu1',uu2',2.0,'r');
hold on

axis equal
axis([0 Lx 0 Ly]);
plot([xf(1:Nf) xf(1)],[yf(1:Nf) yf(1)],'k','linewidth',2); % drop interface 1
if exist('rad2','var')
    plot([xf2(1:Nf2) xf2(1)],[yf2(1:Nf2) yf2(1)],'k','linewidth',2); % drop interface 2
end
text(0.9,0.9,'$|u|$','interpreter','latex');
hold off

% u_1 and u_2 contour plots
subplot1(3)
contourf(xh,yh,uu1',15);
hold on

axis equal
axis([0 Lx 0 Ly]);
plot([xf(1:Nf) xf(1)],[yf(1:Nf) yf(1)],'k','linewidth',2); % drop interface 1
if exist('rad2','var')
    plot([xf2(1:Nf2) xf2(1)],[yf2(1:Nf2) yf2(1)],'k','linewidth',2); % drop interface 2
end
text(0.9,0.9,'$u_1$','interpreter','latex');
hold off

subplot1(4)
contourf(xh,yh,uu2',15);
hold on

axis equal
axis([0 Lx 0 Ly]);
plot([xf(1:Nf) xf(1)],[yf(1:Nf) yf(1)],'k','linewidth',2); % drop interface 1
if exist('rad2','var')
    plot([xf2(1:Nf2) xf2(1)],[yf2(1:Nf2) yf2(1)],'k','linewidth',2); % drop interface 2
end
text(0.9,0.9,'$u_2$','interpreter','latex');

pause(0.01)