function [xf,yf,Nf] = front_maintaince(xf,yf,Nf)
% front_maintaince.m

global dx dy;

% save the existing linked point list
xf_old = xf;
yf_old = yf;

ind = 1; % index for new xf,yf

% loop through the front points
for i=2:Nf+1
    % distance between successive points
    ds = sqrt( ((xf_old(i)-xf(ind))/dx)^2 + ...
               ((yf_old(i)-yf(ind))/dy)^2);

    if (ds > 0.5)
        % add new point
        ind = ind + 1;
        xf(ind) = 0.5*( xf_old(i)+xf(ind-1) );
        yf(ind) = 0.5*( yf_old(i)+yf(ind-1) );

        % add original point
        ind = ind + 1;
        xf(ind) = xf_old(i);
        yf(ind) = yf_old(i);
    elseif (ds < 0.25)
        % delete point (by skipping it)
    else
        % copy point normally for next timestep
        ind = ind + 1;
        xf(ind) = xf_old(i);
        yf(ind) = yf_old(i);
    end
end

% update number of front points
Nf = ind - 1;

% set ghost front points
xf(1)    = xf(Nf+1);
yf(1)    = yf(Nf+1);
xf(Nf+2) = xf(2);
yf(Nf+2) = yf(2);	