% front_consider_merger.m

% for each point of the first front, calculate the minimum distance to any
% point on the second front
min_dists = zeros(1,Nf) + 100.0;

for i=2:Nf+1
   for j=2:Nf2+1
       dist = (xf2(j)-xf(i)).^2 + (yf2(j)-yf(i)).^2;
       if dist < min_dists(i-1)
           min_dists(i-1) = dist;
       end
   end
end

[min_dist,cand_ind] = min(min_dists);
min_dist = sqrt(min_dist);

cand_ind = cand_ind + 1; % make index into [1,Nf+2] size front

% merge if minimum distance is less than grid size
if min_dist < 0.5*dx || min_dist < 0.5*dy
    
    % find again the closest point in the second front to our candidate
    dists = sqrt( (xf2(2:Nf2+1)-xf(cand_ind)).^2 + (yf2(2:Nf2+1)-yf(cand_ind)).^2 );
    
    [min_dist2,front2_ind] = min(dists);
    
    front2_ind = front2_ind + 1; % make index into [1,Nf2+2] size front
    
    fprintf(' MERGER: %d %d %g %g\n',cand_ind,front2_ind,min_dist,min_dist2);

    % merge the two fronts (similar to front_maintaince.m)
    
        % save the existing linked point list for front1
        xf_old = xf;
        yf_old = yf;
        xf = zeros(1,Nf+Nf2+2);
        yf = zeros(1,Nf+Nf2+2);
        
        %debug plot
        %plot(xf_old(2:Nf+2),yf_old(2:Nf+2),'ro--','linewidth',2)
        %hold on
        %plot(xf2(2:Nf2+2),yf2(2:Nf2+2),'bo--','linewidth',2)
        
        ind = 2; % index for new xf,yf

        % until we reach the merger point, just copy front1
        for i=2:cand_ind
            xf(ind) = xf_old(i);
            yf(ind) = yf_old(i);
            ind = ind + 1;
        end
            
        % now loop through front2 starting at the merger point and copy in
        for i=front2_ind:Nf2+1
            xf(ind) = xf2(i);
            yf(ind) = yf2(i);
            ind = ind + 1;
        end

        % finish the front2 loop from the end to the merger point
        for i=2:front2_ind-1
            xf(ind) = xf2(i);
            yf(ind) = yf2(i);
            ind = ind + 1;
        end
            
        % now copy the rest of front1
        for i=cand_ind+1:Nf+1
            xf(ind) = xf_old(i);
            yf(ind) = yf_old(i);
            ind = ind + 1;
        end

        % update number of front points
        Nf_new = ind - 2;
        
        fprintf(' NEW Nf: %d (%d + %d)\n',Nf_new,Nf,Nf2);
        Nf = Nf_new;
        
        % set ghost front points
        xf(1)    = xf(Nf+1);
        yf(1)    = yf(Nf+1);
        xf(Nf+2) = xf(2);
        yf(Nf+2) = yf(2);
        
        %plot(xf(2:Nf+2),yf(2:Nf+2),'k.-','linewidth',2)
    
    % clear rad2, indicates we no longer process the second front
    clear rad2;
end

