function [xf,yf,u1f,u2f] = front_advect(xf,yf,Nf)
% front_advect.m

global dx dy u1 u2 dt;

for i=2:Nf+1
    % u_1 (nearest indices)
    ip = floor(xf(i)/dx)+1;
    jp = floor((yf(i)+0.5*dy)/dy)+1;
    
    % dists to nearest points
    ax = xf(i)/dx-ip+1;
    ay = (yf(i)+0.5*dy)/dy-jp+1;	
    
    % update u_1 (eqn 33)
    u1f(i) = (1.0-ax)*(1.0-ay) * u1(ip,jp)   + ...
             ax*(1.0-ay)       * u1(ip+1,jp) + ...
             (1.0-ax)*ay       * u1(ip,jp+1) + ...
             ax*ay             * u1(ip+1,jp+1);

    % u_2
    ip = floor((xf(i)+0.5*dx)/dx)+1;
    jp = floor(yf(i)/dy)+1;
    
    ax = (xf(i)+0.5*dx)/dx-ip+1;
    ay = yf(i)/dy-jp+1;
    
    u2f(i) = (1.0-ax)*(1.0-ay) * u2(ip,jp)   + ...
             ax*(1.0-ay)       * u2(ip+1,jp) + ...
             (1.0-ax)*ay       * u2(ip,jp+1) + ...
             ax*ay             * u2(ip+1,jp+1);
end     

% actually move it (explicit Euler update) (eqn 34)
xf(2:Nf+1) = xf(2:Nf+1) + dt * u1f(2:Nf+1);
yf(2:Nf+1) = yf(2:Nf+1) + dt * u2f(2:Nf+1);

% set ghost elements of front points
xf(1)    = xf(Nf+1);
yf(1)    = yf(Nf+1);
xf(Nf+2) = xf(2);
yf(Nf+2) = yf(2);