% driver: two_drop_collision.m
% dnelson dec2012
clear all; clc;

% config
setup_globals_two_drops;

% set initial density and viscosity in the box and in the drops
setup_ICs; 

% setup fronts
[xf,yf,xf_start,yf_start] = setup_front_drop(xc,yc,rad,Nf);
[xf2,yf2,xf2_start,yf2_start] = setup_front_drop(xc2,yc2,rad2,Nf2);

% timestep loop
for curstep=1:nstep

    fprintf('[%3d] time = %7.5f \n',curstep,time);
    
    % save solution state at beginning of Delta_x step
    timestep_helper(1);

    % take two substeps for the second order time integration
	for substep=1:2
        
        % calculate surface tension (and map onto grid)
        calc_surface_tension(xf,yf,Nf,1);
        if exist('rad2','var')
            calc_surface_tension(xf2,yf2,Nf2,0);
        end
        
        % calculate u_dagger neglecting pressure
        calc_vel_adv_diff;
        
        % apply pressure correction to u_dagger to obtain u^(n+1)
        pressure_correction_vel;

        % advect the front using corrected velocity field
        [xf,yf,u1f,u2f] = front_advect(xf,yf,Nf);
        if exist('rad2','var')
            [xf2,yf2,u1f2,u2f2] = front_advect(xf2,yf2,Nf2);
        end
        
        % reconstruct density and viscosity everywhere on the domain
        reconstruct_density_mu(xf,yf,Nf,rho2,mu2,0);
        if exist('rad2','var')
            reconstruct_density_mu(xf2,yf2,Nf2,rho3,mu3,1);
        end

	end

    % update the solution vector using the predictor-corrector average
    timestep_helper(2);
    
    time = time+dt;
    
    % maintain good spacing of the front points (by adding/deleting)
    [xf,yf,Nf] = front_maintaince(xf,yf,Nf);
    if exist('rad2','var')
        [xf2,yf2,Nf2] = front_maintaince(xf2,yf2,Nf2);
    end
    
    % consider merger between the drops
    if exist('rad2','var')
        front_consider_merger;
    end
     
    % plotting
    %if mod(curstep,1) == 0, plot_4panels; end; % interactive
    if mod(curstep,10) == 0 || curstep==1, plot_drop_trails; end; % time evo on 1 plot
end
