% driver: drop_bounce.m
% dnelson dec2012
clear all; clc;

% config
setup_globals_one_drop;

% set initial density and viscosity in the box and in the drop
setup_ICs; 

% setup front
[xf,yf,xf_start,yf_start] = setup_front_drop(xc,yc,rad,Nf);

% timestep loop
 for curstep=1:nstep

    fprintf('[%3d] time = %7.5f \n',curstep,time);
    
    % save solution state at beginning of Delta_x step
    timestep_helper(1);

    % take two substeps for the second order time integration
	for substep=1:2
        
        % calculate surface tension (and map onto grid)
        calc_surface_tension(xf,yf,Nf,1);
        
        % calculate u_dagger neglecting pressure
        calc_vel_adv_diff;
        
        % apply pressure correction to u_dagger to obtain u^(n+1)
        pressure_correction_vel;

        % advect the front using corrected velocity field
        [xf,yf,u1f,u2f] = front_advect(xf,yf,Nf);
        
        % reconstruct density and viscosity everywhere on the domain
        reconstruct_density_mu(xf,yf,Nf,rho2,mu2,1);

	end

    % update the solution vector using the predictor-corrector average
    timestep_helper(2);
    
    time = time+dt;
    
    % maintain good spacing of the front points (by adding/deleting)
    [xf,yf,Nf] = front_maintaince(xf,yf,Nf);
     
    % plotting
    if mod(curstep,10) == 0, plot_4panels; end; % interactive
    %if mod(curstep,20) == 0, plot_drop_trails; end; % time evo on 1 plot
end
