% driver: curvature_check.m
% check how well we are measuring the curvature of what should be a circle
% dnelson dec2012
clear all; clc;

% config
xc = 0.5;
yc = 0.5;
rad = 0.3;

Nf_vals = floor(logspace(1,5,500));
curv_err = zeros(length(Nf_vals),1);
c_area = zeros(length(Nf_vals),1);

for i=1:length(Nf_vals)
    Nf = Nf_vals(i);
    
    % positions and tangents
    xf = zeros(1,Nf+2);
    yf = zeros(1,Nf+2);
    tx = zeros(1,Nf+2);
    ty = zeros(1,Nf+2);

    % calculate point positions (linear density drops with increasing Nf)
    %xf = xc - rad * sin(2*pi*linspace(0,Nf+1,Nf+2)/Nf);
    %yf = yc + rad * cos(2*pi*linspace(0,Nf+1,Nf+2)/Nf);
    
    % or: randomize in theta (linear density drops with increasing Nf)
    theta = 2*pi*rand(1,Nf+2);
    theta = sort(theta); % must be ordered to make sense
    xf = cos(theta) * rad + xc;
    yf = sin(theta) * rad + yc;
    
    % calculate area
    c_area(i) = 0.5 * sum( xf(1:Nf+1).*yf(2:Nf+2) - xf(2:Nf+2).*yf(1:Nf+1) );

    % calculate tangents
    ds = sqrt( (xf(2:Nf+2)-xf(1:Nf+1)).^2 + (yf(2:Nf+2)-yf(1:Nf+1)).^2 );

    tx(1:Nf+1) = ( xf(2:Nf+2)-xf(1:Nf+1) ) ./ ds;
    ty(1:Nf+1) = ( yf(2:Nf+2)-yf(1:Nf+1) ) ./ ds;

    tx(Nf+2) = tx(2);
    ty(Nf+2) = ty(2);

    % calculate max curvature
    curv2_x = (tx(2:Nf+1) - tx(1:Nf)) ./ ds(2:Nf+1);
    curv2_y = (ty(2:Nf+1) - ty(1:Nf)) ./ ds(2:Nf+1);
    curv_rad =  sqrt(curv2_x.^2 + curv2_y.^2); % kappa*n has length kappa
    curv_rad = 1 ./ curv_rad; % "radius of curvature" = 1/kappa
    curv_err(i) = abs(mean(curv_rad-rad))./rad;
    
end

loglog(Nf_vals,curv_err,'r-','linewidth',2);
xlabel('number of front points')
ylabel('mean relative curvature error')