% calc_vel_adv_diff.m

 % first handle B.C. (zero tangential velocity on all walls)
u1(1:nx+1,1)    = -u1(1:nx+1,2);
u1(1:nx+1,ny+2) = -u1(1:nx+1,ny+1);
u2(1,1:ny+1)    = -u2(2,1:ny+1);
u2(nx+2,1:ny+1) = -u2(nx+1,1:ny+1);

% u_1^dagger (eqn 19)
for i=2:nx
    for j=2:ny+1
        % advection term (eqn 23)
        u1t(i,j) = u1(i,j) + dt * ( ...
        -0.25*(( (u1(i+1,j)+u1(i,j))^2 - (u1(i,j) +  u1(i-1,j))^2 )/dx + ...
        ...
        ((u1(i,j+1) + u1(i,j))   * (u2(i+1,j)   + u2(i,j)) -  ...
         (u1(i,j)   + u1(i,j-1)) * (u2(i+1,j-1) + u2(i,j-1)))/dy)   + ...
        ...
        fx(i,j)/(0.5*(rho(i+1,j)+rho(i,j)))                          ...  
        ... %- 1.0*gx ); % do not balance grav
        - (1.0 - rho1/(0.5*(rho(i+1,j)+rho(i,j))) )*gx );
        
        % diffusion term (eqn 25)
        u1t(i,j) = u1t(i,j) + dt * (                                   ...
        (1.0/dx)*2.0*(mu(i+1,j)*(1.0/dx)*(u1(i+1,j) - u1(i,j))       - ...
                      mu(i,j)  *(1.0/dx)*(u1(i,j)   - u1(i-1,j)) )     ...
        ...
        +(1.0/dy) * ( 0.25*(mu(i,j)+mu(i+1,j)+mu(i+1,j+1)+mu(i,j+1)) *               ...
        ((1.0/dy) * (u1(i,j+1) - u1(i,j))   + (1.0/dx)*(u2(i+1,j)   - u2(i,j)) )   - ...
        0.25      * (       mu(i,j)+mu(i+1,j)+mu(i+1,j-1)+mu(i,j-1)) *               ...
        ((1.0/dy) * (u1(i,j)   - u1(i,j-1)) + (1.0/dx)*(u2(i+1,j-1) - u2(i,j-1))) )  ...
        ...
        )/(0.5*(rho(i+1,j)+rho(i,j)) );
    end
end

% u_2^dagger (eqn 20)
for i=2:nx+1
    for j=2:ny
        % advection term (eqn 24)
        u2t(i,j) = u2(i,j) + dt * ( ...
        -0.25*(((u1(i,j+1)   + u1(i,j))   * (u2(i+1,j) + u2(i,j))         - ...
                (u1(i-1,j+1) + u1(i-1,j)) * (u2(i,j)   + u2(i-1,j)))/dx   + ...
        ...
        ( (u2(i,j+1)+u2(i,j))^2 - (u2(i,j)+u2(i,j-1))^2 )/dy)             + ...
        ...
        fy(i,j)/(0.5*(rho(i,j+1)+rho(i,j)))                                 ...
        ... %- 1.0*gy ); % do not balance grav
        - (1.0 - rho1/(0.5*(rho(i,j+1)+rho(i,j))) )*gy );
        
        % diffusion term (eqn 26)
        u2t(i,j) = u2t(i,j) + dt * (                                              ...
        (1.0/dx) * ( 0.25*(mu(i,j)+mu(i+1,j)+mu(i+1,j+1)+mu(i,j+1)) *               ...
        ((1.0/dy) * (u1(i,j+1)   - u1(i,j))   + (1.0/dx)*(u2(i+1,j) - u2(i,j)) )  - ...
                     0.25*(mu(i,j)+mu(i,j+1)+mu(i-1,j+1)+mu(i-1,j)) *               ...
        ((1.0/dy) * (u1(i-1,j+1) - u1(i-1,j)) + (1.0/dx)*(u2(i,j)   - u2(i-1,j))) ) ...
        ...
        +(1.0/dy)*2.0*(mu(i,j+1) * (1.0/dy)*(u2(i,j+1) - u2(i,j))               - ...
                       mu(i,j)   * (1.0/dy)*(u2(i,j)   - u2(i,j-1)) )             ...
        ...
        )/(0.5*(rho(i,j+1)+rho(i,j)) );
    end
end
