function calc_surface_tension(xf,yf,Nf,first_drop_flag)
% calc_surface_tension.m

global nx ny sigma dx dy fx fy;

% wipe out old fx,fy
if first_drop_flag==1
    fx = zeros(nx+2,ny+2);
    fy = zeros(nx+2,ny+2);
end

% successive distances
ds = sqrt( (xf(2:Nf+2)-xf(1:Nf+1)).^2 + (yf(2:Nf+2)-yf(1:Nf+1)).^2 );

% tangent vectors
tx = ( xf(2:Nf+2)-xf(1:Nf+1) ) ./ ds;
ty = ( yf(2:Nf+2)-yf(1:Nf+1) ) ./ ds;

% ghosts
tx(Nf+2) = tx(2);
ty(Nf+2) = ty(2);

% smooth f_sigma onto the fixed grid
for i=2:Nf+1
    % term (eqn 7)
    nfx = sigma*(tx(i)-tx(i-1));
    nfy = sigma*(ty(i)-ty(i-1));

    % nearest grid indices (x)
    ip = floor( xf(i)/dx ) + 1; % dx for u1 aligned at x=0
    jp = floor( (yf(i)+0.5*dy)/dy ) + 1; % dy for u1 offset by dy
    
    % distances to nearest grid points
    ax = xf(i)/dx-ip+1;
    ay = (yf(i)+0.5*dy)/dy-jp+1;
    
    % bilinear interp (eqn 36)
    fx(ip,jp)    = fx(ip,jp)     + (1.0-ax) * (1.0-ay) * nfx/dx/dy;
    fx(ip,jp+1)  = fx(ip,jp+1)   + (1.0-ax) * ay       * nfx/dx/dy;
    fx(ip+1,jp)  = fx(ip+1,jp)   + ax       * (1.0-ay) * nfx/dx/dy;
    fx(ip+1,jp+1)= fx(ip+1,jp+1) + ax       * ay       * nfx/dx/dy;

    % (y)
    ip = floor( (xf(i)+0.5*dx )/dx) + 1; % dx for u2 offset by dx
    jp = floor( yf(i)/dy ) + 1; % dy for u2 aligned at y=0
    
    ax = (xf(i)+0.5*dx)/dx - ip + 1;
    ay = yf(i)/dy - jp + 1;
    
    fy(ip,jp)    = fy(ip,jp)     + (1.0-ax) * (1.0-ay) * nfy/dx/dy;
    fy(ip,jp+1)  = fy(ip,jp+1)   + (1.0-ax) * ay       * nfy/dx/dy;
    fy(ip+1,jp)  = fy(ip+1,jp)   + ax       * (1.0-ay) * nfy/dx/dy;
    fy(ip+1,jp+1)= fy(ip+1,jp+1) + ax       * ay       * nfy/dx/dy;  
end